#import <Foundation/Foundation.h>

@interface NSString (printing)
- (void)print;
@end
@implementation NSString (printing)
- (void)print
{
	fprintf(stderr, "%s\n", [self UTF8String]);
}
@end

int main(void)
{
	[NSAutoreleasePool new];
	NSArray* a = 
		[NSArray arrayWithObjects: @"to", @"jest", @"tablica", nil];

	NSLog(@"Sposob z Objective-C 1:");
	NSEnumerator *e=[a objectEnumerator];
	for (id obj=[e nextObject] ;
		   	nil!=obj ;
		   	obj=[e nextObject])
	{
		[obj print];
	}
	NSLog(@"Szybkie enumerowanie:");
	for (id obj in a)
	{
		[obj print];
	}
	NSLog(@"Z wykorzystaniem blokow:");
	[a enumerateObjectsUsingBlock: 
		^(id obj, NSUInteger idx, BOOL *stop)
		{
			[obj print];
		}];
	NSLog(@"Unikajac enumerowania:");
	[a makeObjectsPerformSelector: @selector(print)];
	return 0;
}
