#import <Foundation/Foundation.h>

@interface Tracker : NSObject
@end
static NSString *ProcessDidStart =
 @"ProcessDidStartNotification";
@implementation Tracker
- (void)newCopyStarted: (NSNotification*)n
{
	NSLog(@"Nowa instancja %@ wystartowala z identyfikatorem procesu (pid): %@",
		[n object], 
		[[n userInfo] objectForKey: @"pid"]);
}
- (id)init
{
	NSDistributedNotificationCenter *c =
		[NSDistributedNotificationCenter defaultCenter];

	[c     addObserver: self
	          selector: 
		@selector(newCopyStarted:)
	              name: ProcessDidStart
	            object: nil
	suspensionBehavior: 
		NSNotificationSuspensionBehaviorHold];

	NSProcessInfo *pinfo = 
		[NSProcessInfo processInfo];
	NSNumber *pid = [NSNumber numberWithInt:
		[pinfo processIdentifier]];
	NSDictionary *userInfo = [NSDictionary
		dictionaryWithObject: pid
		              forKey: @"pid"];

	[c postNotificationName: ProcessDidStart
	                 object: [pinfo processName]
	               userInfo: userInfo
	                options: 0];
	[[NSRunLoop currentRunLoop] run];
}
@end

int main(void)
{
	[NSAutoreleasePool new];
	[Tracker new];
	return 0;
}
