#import <Foundation/Foundation.h>
#include <objc/runtime.h>

int main(void)
{
	[NSAutoreleasePool new];
	NSMutableArray *classes = 
		[NSMutableArray new];
	int classCount = 
		objc_getClassList(NULL, 0);
	Class *classList = 
		calloc(classCount, sizeof(Class));
	objc_getClassList(classList, 
			classCount);
	for (int i=0 ; i<classCount ; i++)
	{
		[classes addObject: 
			NSStringFromClass(
				classList[i])];
	}
	free(classList);
	[classes sortUsingSelector: 
			 @selector(compare:)];
	for (NSString *className in classes)
	{
		const char *name = [className UTF8String];
		printf("%s\n\tIvars:\n", name);
		Class cls = NSClassFromString(className);
		unsigned int ivarCount;
		Ivar *ivars = 
			class_copyIvarList(cls, &ivarCount);
		for (unsigned int i=0 ; i<ivarCount ; i++)
		{
			printf("\t\t%s\n", ivar_getName(ivars[i]));
		}
		free(ivars);
		unsigned int methodCount;
		Method *methods = 
			class_copyMethodList(cls, &methodCount);
		printf("%s\n\tMetody:\n", name);
		for (unsigned int i=0 ; i<methodCount ; i++)
		{
			printf("\t\t%s\n", 
					sel_getName(method_getName(methods[i])));
		}
	}
	return 0;
}
