#import <Foundation/Foundation.h>

int main(int argc, char **argv)
{
	if (argc < 2) { return 1; }
	[NSAutoreleasePool new];
	NSString *file =
		[NSString stringWithUTF8String: argv[1]];
	NSData *data = [NSData dataWithContentsOfFile:
		file];
	NSPropertyListFormat fmt;
	id plist = [NSPropertyListSerialization 
		propertyListWithData: data
		             options: 0
		              format: &fmt
		               error: NULL];
	if (fmt == NSPropertyListBinaryFormat_v1_0)
	{
		return 0;
	}
	data = [NSPropertyListSerialization
		dataWithPropertyList: plist
		              format: NSPropertyListBinaryFormat_v1_0
		             options: 0
		               error: NULL];

	[data writeToFile: file atomically: NO];
	return 0;
}
