#import <Foundation/Foundation.h>

@interface Pair : NSObject <NSCopying>
@property (nonatomic, retain) id first, second;
@end
@implementation Pair
@synthesize first, second;
- (id)copyWithZone: (NSZone*)aZone
{
	Pair *new = [self->isa allocWithZone: aZone];
	new.first = first;
	new.second = second;
	return new;
}
@end

int main(void)
{
	[NSAutoreleasePool new];
	Pair *a = [Pair new];
	a.first = @"first";
	a.second = @"second";
	Pair *b = [a copy];
	NSLog(@"a: %@, b: %@", a, b);
	return 0;
}

@implementation Pair (Describe)
- (NSString*)description
{
	return [NSString stringWithFormat: @"(%@, %@)", first, second];
}
@end
