#import <Foundation/Foundation.h>

@protocol Collection
- (BOOL)isEmpty;
@end
@interface NSArray (Collection) <Collection> @end
@interface NSSet (Collection) <Collection> @end
@implementation NSArray (Collection)
- (BOOL)isEmpty
{
	return [self count] == 0;
}
@end
@implementation NSSet (Collection)
- (BOOL)isEmpty
{
	return [self count] == 0;
}
@end

int main(void)
{
	[NSAutoreleasePool new];
	NSArray *array = [NSArray new];
	NSSet *set = [NSSet new];
	NSCAssert([array conformsToProtocol: @protocol(Collection)],
		@"klasa NSArray powinna byc zgodna z protokolem Collection");
	NSCAssert([set conformsToProtocol: @protocol(Collection)],
		@"klasa NSSet powinna byc zgodna z protokolem Collection");
	return 0;
}
