#import <Foundation/Foundation.h>

@interface TypedArray : NSMutableArray
{
	Class type;
	NSMutableArray *realArray;
}
@end
@implementation TypedArray
- (id)initWithType: (Class)aClass
{
	if (nil == (self = [super init]))
	{
		return nil;
	}
	type = aClass;
	realArray = [NSMutableArray new];
	return self;
}
- (void)dealloc
{
	[realArray release];
	[super dealloc];
}
- (NSUInteger)count
{
	return [realArray count];
}
- (id)objectAtIndex: (NSUInteger)anIndex
{
	return 
		[realArray objectAtIndex: anIndex];
}
- (void)insertObject: (id)anObject
             atIndex: (NSUInteger)anIndex
{
	if (![anObject isKindOfClass: type])
	{
		return;
	}
	[realArray insertObject: anObject
	                atIndex: anIndex];
}
- (void)removeObjectAtIndex: (NSUInteger)idx
{
	[realArray removeObjectAtIndex: idx];
}
- (void)addObject: (id)anObject
{
	if (![anObject isKindOfClass: type])
	{
		return;
	}
	[realArray addObject: anObject];
}
- (void)removeLastObject
{
	[realArray removeLastObject];
}
- (void)replaceObjectAtIndex: (NSUInteger)idx
                  withObject: (id)anObject
{
	if (![anObject isKindOfClass: type])
	{
		return;
	}
	[realArray replaceObjectAtIndex: idx
	                     withObject: anObject];
}
@end

int main(void)
{
	[NSAutoreleasePool new];
	NSMutableArray *array = 
		[[TypedArray alloc] initWithType: [NSString class]];
	[array addObject: @"ciag znakowy"];
	[array addObject: @"inny ciag znakowy"];
	[array addObject: [NSObject new]];
	NSLog(@"Tablica: %@", array);
	return 0;
}
