#import <Foundation/Foundation.h>

@interface Singleton : NSObject
@end
@implementation Singleton
static Singleton *sharedInstance;
+ (void)initialize
{
	if ([Singleton class] == self)
	{	
		sharedInstance = [self new];
	}
}
+ (Singleton*)sharedInstance
{
	return sharedInstance;
}
+ (id)allocWithZone: (NSZone*)aZone
{
	if (sharedInstance && 
	    [Singleton class] == self)
	{
		[NSException raise: NSGenericException
		            format: @"Nie mozna utworzyc wiecej niz 1 instancji singletonu."];
	}
	return [super allocWithZone: aZone];
}
@end
