#import <Foundation/Foundation.h>

@interface Listener : NSObject @end
@implementation Listener
- (void)notify: (NSNotification*)note
{
	NSLog(@"Otrzymano %@", note);
}
- (void)registerListener
{
	NSNotificationCenter *nc =
		[NSNotificationCenter defaultCenter];
	[nc addObserver: self
		   selector: @selector(notify:)
			   name: @"Przyklad"
			 object: nil];
}
- (void)dealloc
{
	NSNotificationCenter *nc =
		[NSNotificationCenter defaultCenter];
	[nc removeObserver: self];
	[super dealloc];
}
@end


int main(void)
{
	[NSAutoreleasePool new];
	Listener *l = [Listener new];
	[l registerListener];
	NSNotificationCenter *nc =
		[NSNotificationCenter defaultCenter];
	[nc postNotificationName: @"Przyklad"
	                  object: @"sender"
  	                userInfo: nil];
	[l release];
	// No listeners now exist for this one:
	[nc postNotificationName: @"Przyklad"
	                  object: @"sender"
  	                userInfo: nil];
	[[Listener new] registerListener];
	NSNotificationQueue *nq =
		[NSNotificationQueue defaultQueue];
	NSNotification *note = [NSNotification 
		notificationWithName: @"Przyklad"
		              object: @"sender"];
	[nq enqueueNotification: note
	           postingStyle: NSPostWhenIdle];
	[[NSRunLoop currentRunLoop] run];
	return 0;
}
