#import <Foundation/Foundation.h>


@interface Watcher : NSObject @end
@implementation Watcher
+ (void)observeValueForKeyPath: 
                (NSString*)keyPath
      ofObject: (id)object
        change: (NSDictionary*)change
       context: (void*)context
{
	NSLog(@"%@.%@ jest teraz %@", object, keyPath,
		[change objectForKey: NSKeyValueChangeNewKey]);
}
@end

@interface Notifier : NSObject 
{
	int aKey;
}
@property (nonatomic, assign) int aKey;
@end
@implementation Notifier
@synthesize aKey;
- (void)watchChange
{
	id obj = [Watcher class];
	[self addObserver: obj
	       forKeyPath: @"aKey"
	          options: 
		NSKeyValueObservingOptionNew
	          context: NULL];

	[self setValue: @"42"
	        forKey: @"aKey"];
	self.aKey = 12;
	[self willChangeValueForKey: @"aKey"];
	aKey = 47;
	[self didChangeValueForKey: @"aKey"];

	[self removeObserver: obj
	          forKeyPath: @"aKey"];
}
@end

int main(void)
{
	[NSAutoreleasePool new];
	[[Notifier new] watchChange];
	return 0;
}
