#import <Cocoa/Cocoa.h>

int main(int argc, char **argv)
{
	[NSAutoreleasePool new];
	NSUserDefaults *def = 
		[NSUserDefaults standardUserDefaults];
	NSData *serialized = [def objectForKey: @"color"];
	
	id favoriteColor =
		[NSKeyedUnarchiver unarchiveObjectWithData:
			serialized];

	if (nil == favoriteColor)
	{
		favoriteColor = [NSColor blackColor];
		serialized = [NSKeyedArchiver 
			archivedDataWithRootObject: favoriteColor];
		[def setObject: serialized
		        forKey: @"color"];
		[def synchronize];
	}
	return 0;
}
