#import <Foundation/Foundation.h>

@interface CodingExample : NSObject<NSCoding>
{
	int integer;
	NSString *string;
}
@property int integer;
@property (nonatomic, retain) NSString *string;
@end
@implementation CodingExample
- (id)initWithCoder: (NSCoder*)aCoder
{
	if ([aCoder versionForClassName: [self className]] != 0)
	{ 
		[self release];
		return nil;
	}
	if ([aCoder allowsKeyedCoding])
	{
		integer = 
			[aCoder decodeIntForKey: @"integer"];
		string = [aCoder decodeObjectForKey: @"string"];
	}
	else
	{
		[aCoder decodeValueOfObjCType: @encode(int)
		                           at: &integer];
		string = [aCoder decodeObject];
	}
	string = [string retain];
	return self;
}
- (void)encodeWithCoder: (NSCoder*)aCoder
{
	if ([aCoder allowsKeyedCoding])
	{
		[aCoder encodeInt: integer
		           forKey: @"integer"];
		[aCoder encodeObject: string
		              forKey: @"string"];
	}
	else
	{
		[aCoder encodeValueOfObjCType: @encode(int)
		                           at: &integer];
		[aCoder encodeObject: string];
	}

}
@synthesize integer, string;
@end


void roundTripWithArchiver(id object, Class coder, Class decoder)
{
	NSData *data = [coder archivedDataWithRootObject: object];
	id copy = [decoder unarchiveObjectWithData: data];
	NSCAssert(data, @"Archiwizacja nie powiodla sie");
	NSCAssert(copy, @"Odczytywanie zarchwizowanych danych nie powiodlo sie");
	NSCAssert(([object integer] == [copy integer]), 
			@"Liczba nie zostala poprawnie skopiowana");
	NSCAssert([[object string] isEqual: [copy string]],
			@"Ciag znakowy nie zostal poprawnie skopiowany");
}

int main(void)
{
	[NSAutoreleasePool new];
	CodingExample *obj = [CodingExample new];
	obj.integer = 42;
	obj.string = @"String!";
	
	roundTripWithArchiver(obj, [NSKeyedArchiver class], [NSKeyedUnarchiver class]);
	roundTripWithArchiver(obj, [NSArchiver class], [NSUnarchiver class]);
	return 0;
}
