#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#import <Foundation/Foundation.h>

@implementation NSFileHandle (SocketAdditions)
+ (NSFileHandle*)fileHandleConnectedToRemoteHost: (NSString*)aHost
                                       forService: (NSString*)aService
{
	const char * server = [aHost UTF8String];
	const char * service = [aService UTF8String];
	struct addrinfo hints, *res0;
	int error;

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = PF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	//Pobierz adres strumienia.
	error = getaddrinfo(server, service, &hints, &res0);
	if (error) { return nil; }

	int s = -1;
	for (struct addrinfo *res = res0; 
		res != NULL && s < 0 ; 
		res = res->ai_next) 
	{
		s = socket(res->ai_family, res->ai_socktype,
			res->ai_protocol);
		//Jesli socket jest w stanie bledu, sprobuj nastepny adres
		if (s < 0) { continue ; }

		//Jesli polaczenie jest w stanie bledu, sprobuj nastepny adres
		if (connect(s, res->ai_addr, res->ai_addrlen) < 0) 
		{
			close(s);
			s = -1;
			continue;
		}
	}
	freeaddrinfo(res0);
	if (s < 0) { return nil; }
	return 
		[[[NSFileHandle alloc] 
			initWithFileDescriptor: s
			        closeOnDealloc: YES]
				autorelease];
}
@end
