#import <Foundation/Foundation.h>

@interface NetService : NSObject<NSNetServiceBrowserDelegate>
- (void)publishAndFind;
@end

@implementation NetService
- (void)publishAndFind
{
	NSString *type =
		@"_exampleService._tcp.";
	NSProcessInfo *pi = [NSProcessInfo processInfo];
	NSString *name = 
		[NSString stringWithFormat: @"%@/%@", 
			 [pi hostName],
			 NSFullUserName()];

	NSNetService *service = 
		[[NSNetService alloc] 
			initWithDomain: @""
			          type: type
			          name: name
		              port: 123];
	[service publish];

	NSNetServiceBrowser *sb =
	   [NSNetServiceBrowser new];
	[sb setDelegate: self];
	[sb searchForServicesOfType: type
	                   inDomain: @""];
}
- (void)netServiceBrowser: (NSNetServiceBrowser*)netServiceBrowser
           didFindService: (NSNetService*)netService
               moreComing: (BOOL)moreServicesComing
{
	NSLog(@"Znaleziono: %@", [netService name]);
}
@end

int main(void)
{
	[NSAutoreleasePool new];
	[[NetService new] publishAndFind];
	[[NSRunLoop currentRunLoop] run];
	return 0;
}
