#import <Foundation/Foundation.h>

int main(int argc, char **argv, char **envp)
{
	// The C way
	while (*envp)
	{
		printf("%s\n", *envp);
		envp++;
	}
	printf("Katalog roboczy: %s\n", getenv("PWD"));

	// The Objective-C way
	[NSAutoreleasePool new];
	NSDictionary *env =
		[[NSProcessInfo processInfo] environment];
	for (NSString *key in env)
	{
		NSLog(@"%@ = %@", key, [env objectForKey: key]);
	}
	NSLog(@"Katalog roboczy: %@\n", 
			[env objectForKey: @"PWD"]);
	return 0;
}
