#import <Foundation/Foundation.h>

@interface MessageSend : NSObject {
	/** Odbiorca wiadomosci. */
	id target;
	/** Selektor wiadomosci */
	NSString * selector;
	/** Tablica wezlow AST odpowiadajaca argumentom wiadomosci */
	NSMutableArray * arguments;
	/** Typy dla metody */
	const char *type;
}
@end

@implementation MessageSend 
- (id)initWithSelectorName: (NSString*)aSel
                 arguments: (NSArray*)args
{
	if (nil == (self = [super init]))
		{ return nil; }
	selector = [aSel copy];
	arguments = [args mutableCopy];
	return self;
}
- (id)initWithSelectorName:(NSString*)aSel
{
	return 
		[self initWithSelectorName: aSel
		                 arguments: nil];
}
- (id)init
{
	return [self initWithSelectorName: nil];
}
- (void)dealloc
{
	[selector release];
	[target release];
	[arguments release];
	[super dealloc];
}
@end
