#import <Foundation/Foundation.h>

@interface ThreadedQueue : NSThread
{
	NSCondition *condition;
	int queueSize;
}
@end
@implementation ThreadedQueue
- (id)init
{
	if (nil == (self = [super init])) 
	{
		return nil;
	}
	condition = [NSCondition new];
	return self;
}
- (void)addToQueue
{
	[condition lock];
	queueSize++;
	[condition signal];
	[condition unlock];
}
- (void)main
{
	while (1)
	{
		id pool = [NSAutoreleasePool new];
		[condition lock];
		while (queueSize == 0)
		{
			[condition wait];
		}
		queueSize--;
		[condition unlock];
		NSLog(@"Przetworzono dane z kolejki");
		[pool release];
	}
}
- (void)dealloc
{
	[condition release];
	[super dealloc];
}
@end

int main(void)
{
	[NSAutoreleasePool new];
	id threadedQueue = [ThreadedQueue new];
	[threadedQueue start];
	[threadedQueue addToQueue];
	[threadedQueue addToQueue];
	[threadedQueue addToQueue];
	[threadedQueue addToQueue];
	[threadedQueue addToQueue];
	[threadedQueue addToQueue];
	[threadedQueue addToQueue];
	sleep(1);
	return 0;
}
