#import <Foundation/Foundation.h>

@interface IgnoreAsserts : NSAssertionHandler
@end
@implementation IgnoreAsserts
- (void)handleFailureInFunction: (NSString*)functionName
             file: (NSString*)fileName
       lineNumber: (NSInteger)line
      description: (NSString *)format, ...
{
	NSLog(@"Ignoruje asercje w linii %d w metodzie %@() w %@", line, functionName, fileName);
}
@end

int main(void)
{
	[NSAutoreleasePool new];
	[[[NSThread currentThread] threadDictionary]
		setObject: [[IgnoreAsserts new] autorelease]
		   forKey: NSAssertionHandlerKey];
	NSCAssert(1 == 2, @"Moze to nie byc prawda");
	return 0;
}
