/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licencja Apache, wersja 2.0
 * Uywanie pliku niezgodnie z warunkami licencji zabronione.
 * Licencja jest dostpna pod adresem:
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * O ile nie wymaga tego obowizujce prawo, lub na pimie nie postanowi si inaczej,
 * oprogramowanie objte t licencj jest rozpowszechniane w takim stanie, w jakim jest
 * be adnych gwarancji ani warunkw, ani jawnych, ani domylnych.
 * Szczegowe warunki okrelaj waciwe przepisy i ograniczenia zawarte w tej Licencji
 * 
 */


package org.simonmonk.rangefinder;



import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;

public class BaseActivity extends DroidGeigerActivity {

	private InputController mInputController;

	public BaseActivity() {
		super();
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		if (mAccessory != null) {
			showControls();
		} else {
			hideControls();
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		menu.add("Kasuj");
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		if (item.getTitle() == "Kasuj") {
			showControls();
			mInputController.clearLog();
		} 
		return true;
	}

	protected void enableControls(boolean enable) {
		if (enable) {
			showControls();
		} else {
			hideControls();
		}
	}

	protected void hideControls() {
		setContentView(R.layout.no_device);
		mInputController = null;
	}

	protected void showControls() {
		setContentView(R.layout.main);

		mInputController = new InputController(this);
		mInputController.accessoryAttached();
	}

	protected void handleGeigerMessage(ValueMsg t) {
		if (mInputController != null) {
			mInputController.handleGeigerMessage(t.getFlag(), t.getReading());
		}
	}


}