/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licencja Apache, wersja 2.0
 * Uywanie pliku niezgodnie z warunkami licencji zabronione.
 * Licencja jest dostpna pod adresem:
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * O ile nie wymaga tego obowizujce prawo, lub na pimie nie postanowi si inaczej,
 * oprogramowanie objte t licencj jest rozpowszechniane w takim stanie, w jakim jest
 * be adnych gwarancji ani warunkw, ani jawnych, ani domylnych.
 * Szczegowe warunki okrelaj waciwe przepisy i ograniczenia zawarte w tej Licencji
 * 
 */ 

package org.simonmonk.sounddisplay;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;

/* Ponisza aktywno nie wykonuje adnych innych czynnoci poza odbieraniem zdarze
 * USB_DEVICE_ATTACHED z usugi USB i springboardu i przesyaniem ich do aktywnoci gwnej galerii
 */
public final class UsbAccessoryActivity extends Activity {

	static final String TAG = "UsbAccessoryActivity";

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		Intent intent = DroidRangeFinderLaunch.createIntent(this);
		intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK
				| Intent.FLAG_ACTIVITY_CLEAR_TOP);
		try {
			startActivity(intent);
		} catch (ActivityNotFoundException e) {
			Log.e(TAG, "nieudane uruchomienie aktywnoci", e);
		}
		finish();
	}
}
