/**
 * Kod rdowy do ksiki Projekty Arduino + Android dla Maych Geniuszy
 * Copyright 2011 Simon Monk
 *
 * Ten program jest otwartym oprogramowaniem, moesz je rozpowszechnia i modyfikowa
 * zgodnie z warunkami Powszechnej Licencja Publicznej GNU w wersji 2,
 * opublikowanej przez Free Software Foundation (patrz sekcja KOPIOWANIE).
 
 * Niniejszy program rozpowszechniany jest z nadziej, i bdzie on 
 * uyteczny - jednak BEZ JAKIEJKOLWIEK GWARANCJI, nawet domylnej 
 * gwarancji PRZYDATNOCI HANDLOWEJ albo PRZYDATNOCI DO OKRELONYCH 
 * ZASTOSOWA. W celu uzyskania bliszych informacji patrz Powszechna 
 * Licencja Publiczna GNU. 
 */

package org.simonmonk.geiger;

import java.util.Date;


import org.simonmonk.geiger.R;

import android.media.MediaPlayer;
import android.text.format.DateFormat;
import android.util.Log;
import android.widget.ImageView;
import android.widget.TextView;

public class InputController extends AccessoryController {
	private TextView mTemperature;
	private ImageView mRadiationImage;
	private TextView mLogView;
	
	private DroidGeigerActivity mHostActivity;
	private MediaPlayer mp;
	

	InputController(DroidGeigerActivity hostActivity) {
		super(hostActivity);
		mHostActivity = hostActivity;
		mTemperature = (TextView) findViewById(R.id.tempValue);
		mRadiationImage = (ImageView) findViewById(R.id.radImage);
		mLogView = (TextView) findViewById(R.id.logField);
		mp = MediaPlayer.create(mHostActivity, R.raw.click);

		mRadiationImage.setVisibility(ImageView.INVISIBLE);

	}

	
	protected void onAccesssoryAttached() {
	}
	
	public void clearLog()
	{
		mLogView.setText("Czas\t\t\tIlo");
	}

	public void handleGeigerMessage(char flag, int reading) {
		Log.d("SRM", "setTemp " + reading);
		if (flag == 'E')
		{
			mRadiationImage.setVisibility(ImageView.VISIBLE);
			mp.start();
		}
		else if (flag == 'R')
		{
			mRadiationImage.setVisibility(ImageView.INVISIBLE);
			mTemperature.setText("" + reading);
		}
		else if (flag == 'L')
		{
			String logText = mLogView.getText().toString();
			String timeFormatted = (String) DateFormat.format("hh:mm", new Date());
			mLogView.setText(logText + "\n" + timeFormatted + "\t\t\t" + reading);
		}
	}



}
