package objects;

import org.junit.Test;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.junit.Assert.*;

public class ObjectsDemoTest {
    private ObjectsDemo demo = new ObjectsDemo();

    @Test
    public void getStrings() throws Exception {
        List<String> strings = Arrays.asList("to", "jest", "lista", "acuchw", "tekstowych");
        assertTrue(Objects.deepEquals(strings, demo.getStrings()));
    }

    @Test
    public void getNonNullStrings() throws Exception {
        List<String> strings = Arrays.asList("to", "jest", "lista", null, "acuchw", null, "tekstowych");
        demo.setStrings(strings);
        assertTrue(Objects.deepEquals(
                Arrays.asList("to", "jest", "lista", "acuchw", "tekstowych"),
                demo.getNonNullStrings()));
    }

    @Test
    public void getNonNullElements() throws Exception {
        Random random = new Random();
        List<Double> doubles = random.doubles()
                .limit(10)
                .mapToObj(r -> r < 0.5 ? null : r)
                .collect(Collectors.toList());
        System.out.println(doubles);
        List<Double> nonNullElements = demo.getNonNullElements(doubles);
        System.out.println(nonNullElements);
        nonNullElements.forEach(r ->
            assertTrue(Objects.nonNull(r)));
    }
}