package defaults;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class StaticMethodsDemo {
    public static void main(String[] args) {
        List<String> bonds = Arrays.asList("Connery", "Lazenby", "Moore", "Dalton",
                "Brosnan", "Craig");

        // naturalny porzdek
        List<String> sorted = bonds.stream()
                .sorted(Comparator.naturalOrder())  // to samo, co sorted()
                .collect(Collectors.toList());
        System.out.println(sorted);

        // odwrcony porzdek naturalny
        sorted = bonds.stream()
                .sorted(Comparator.reverseOrder())
                .collect(Collectors.toList());
        System.out.println(sorted);

        // sortowanie wg nazwiska i maych liter
        sorted = bonds.stream()
                .sorted(Comparator.comparing(String::toLowerCase))
                .collect(Collectors.toList());
        System.out.println(sorted);

        // sortowanie wg dugoci
        sorted = bonds.stream()
                .sorted(Comparator.comparingInt(String::length))
                .collect(Collectors.toList());
        System.out.println(sorted);

        // sortowanie wg dugoci i porzdku naturalnego
        sorted = bonds.stream()
                .sorted(Comparator.comparingInt(String::length)
                        .thenComparing(Comparator.naturalOrder()))
                .collect(Collectors.toList());
        System.out.println(sorted);
    }
}
