package datetime;

import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Set;

public class JavaTimeDemos {
    public static void main(String[] args) {
        Instant now = Instant.now();
        System.out.printf("Instant.now(): %s%n", now);

        Instant then = now.plus(1, ChronoUnit.DAYS);
        Duration elapsed = Duration.between(now, then);
        System.out.printf("Czas trwania po dodaniu 1 dnia: %s%n", elapsed);
        System.out.printf("Czas trwania w dniach: %d days%n", elapsed.toDays());
        System.out.printf("Czas trwania w godzinach: %d hours%n", elapsed.toHours());

        then = now.plus(1, ChronoUnit.DAYS)
                .plus(1, ChronoUnit.HALF_DAYS)
                .plus(1, ChronoUnit.HOURS)
                .plus(10, ChronoUnit.MINUTES)
                .plusSeconds(10)
                .plusMillis(100)
                .plusNanos(100);
        System.out.printf("Dodawanie jednostek do now: %s%n", then);

        LocalDate date1 = LocalDate.now();
        System.out.printf("LocalDate.now() %s%n", date1);

        LocalDate groundHogDay =
                LocalDate.of(2018, Month.FEBRUARY, 2);
        System.out.printf("Dzie wiastaka 2016: %s%n", groundHogDay);

        LocalDate firstDayofSpring =
                LocalDate.of(2018, Month.MARCH, 20);
        System.out.printf("Pierwszy dzie wiosny 2016: %s%n", firstDayofSpring);

        // dzie tygodnia dostpny
        System.out.println("Pierwszy dzie wiosny w tym roku wypada w " +
                firstDayofSpring.getDayOfWeek());

        // until z ChronoUnit daje liczb dni pomidzy
        long gap = groundHogDay.until(firstDayofSpring, ChronoUnit.DAYS);
        System.out.println("Dzie wistaka i pierwszy dzie wiosny dzieli " + gap +
                " dni");
        System.out.printf("To %d tygodni i %d dni%n", gap / 7, gap % 7);

        // zabawa ze strefami czasowymi
        Set<String> availableTimeZones = ZoneId.getAvailableZoneIds();
        System.out.printf("Liczba wszystkich stref czasowych: %d%n",
                availableTimeZones.size());
        availableTimeZones.stream()
                .filter(name -> name.contains("America"))
                .forEach(System.out::println);

        ZonedDateTime missing = ZonedDateTime.of(
                LocalDate.of(2015, Month.MARCH, 8),
                LocalTime.of(2, 30),      
                ZoneId.of("America/Chicago"));
        System.out.println(missing);

        ZonedDateTime spring =
                ZonedDateTime.of(2015, 3, 20, 0, 0, 0, 0, ZoneId.systemDefault());

        System.out.println(
                DateTimeFormatter.RFC_1123_DATE_TIME.format(spring));
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG)
                .withLocale(Locale.FRANCE);
        System.out.println(formatter.format(spring));

        LocalDateTime dateTime = LocalDateTime.of(2017, Month.JULY, 4, 13, 20, 10);
        ZonedDateTime nyc = dateTime.atZone(ZoneId.of("America/New_York"));
        System.out.println(nyc);

        ZonedDateTime london = nyc.withZoneSameInstant(ZoneId.of("Europe/London"));
        System.out.println(london);

    }
}
