<?php # index.php
// To główna strona WWW witryny.
// Wyświetla listę trwających aukcji.

// Plik konfiguracyjny zawsze musi pojawić się jako pierwszy:
require('includes/config.inc.php');

// Ustaw tytuł strony i dodaj nagłówek HTML:
$page_title = 'Trwające aukcje';
include ('includes/header.html');

// Umożliwia wylogowanie:
//$_SESSION = array();

// Wyświetl aktualnie trwające aukcje:
echo '<h1>Aktualnie trwające aukcje</h1>
	<p>Aukcje wymienione są od kończących się najszybciej. ';
	
if (isset($_SESSION['timezone'])) {
	echo 'Wszystkie czasy podawane są w wybranej przez Ciebie strefie czasowej. ';
} else {
	echo 'Wszystkie czasy podawane są z użyciem czasu uniwersalnego. <a href="logowanie.php">Zaloguj się</a>, aby czasy były podawane w wybranej przez Ciebie strefie czasowej. ';
}

// Rozpocznij tabelę:
echo '</p><table>
	<caption>Kliknij przedmiot, aby zobaczyć szczegóły aukcji.</caption>
		<thead><tr><th>Przedmiot</th><th>Aktualna cena</th><th>Data zakończenia aukcji</th></tr></thead>
		<tbody>
';

// Potrzebne jest połączenie z bazą danych:
require(MYSQL);

// Jeśli użytkownik jest zalogowany i wybrał strefę czasową,
// użyj jej do skonwertowania daty i czasu:
if (isset($_SESSION['timezone'])) {
	$tz = "CONVERT_TZ(dateClosed, 'UTC', '{$_SESSION['timezone']}')";
} else {
	$tz = 'dateClosed';
}

// Wykonaj zapytanie:
$q = "SELECT items.itemId, item, COALESCE(MAX(bid), openingPrice), IF(dateClosed < DATE_ADD(UTC_TIMESTAMP(), INTERVAL 24 HOUR), DATE_FORMAT($tz,'%H:%i'), DATE_FORMAT($tz,'%Y-%m-%d @ %H:%i')) FROM items LEFT JOIN bids USING (itemId) WHERE dateClosed > UTC_TIMESTAMP() GROUP BY items.itemId ORDER BY dateClosed ASC";
$r = mysqli_query ($dbc, $q) or trigger_error("Zapytanie: $q\n<br />Błąd MySQL: " . mysqli_error($dbc));
// Wyświetl elementy w tabeli:
while (list($itemId, $item, $price, $dateClosed) = mysqli_fetch_array($r, MYSQLI_NUM)) {
	echo "<tr><td><a href=\"widok.php?itemId=$itemId\">$item</a></td><td>\$$price</td><td>$dateClosed</td></tr>\n";
}

// Czyszczenie:
mysqli_free_result($r);
mysqli_close($dbc);

// Zamknij tabelę:
echo '</tbody></table>';

// Dołącz stopkę:
include ('includes/footer.html'); 
?>