// register.js
// Skrypt waliduje formularz.

// Funkcja wywoływana w momencie wysyłki formularza.
// Funkcja sprawdza dane formularza.
function validateForm(e) {
    'use strict';

    // Pobierz obiekt zdarzenia:
	if (typeof e == 'undefined') e = window.event;

    // Pobierz referencje do elementów formularza:
	var firstName = U.$('firstName');
	var lastName = U.$('lastName');
	var email = U.$('email');
	var phone = U.$('phone');
	var city = U.$('city');
	var state = U.$('state');
	var zip = U.$('zip');
	var terms = U.$('terms');

	// Zmienna błędu:
	var error = false;

	// Sprawdź poprawność imienia:
	if (/^[A-Z \.\-']{2,20}$/i.test(firstName.value)) {
		removeErrorMessage('firstName');
	} else {
		addErrorMessage('firstName', 'Proszę wpisać imię.');
		error = true;
	}
	
	// Sprawdź poprawność adresu e-mail:
	if (/^[\w.-]+@[\w.-]+\.[A-Za-z]{2,6}$/.test(email.value)) {
		removeErrorMessage('email');
	} else {
		addErrorMessage('email', 'Proszę wpisać poprawny adres e-mail.');
		error = true;
	}
	
	// Sprawdź poprawność numeru telefonu:
	if (/\d{3}[ \-\.]?\d{3}[ \-\.]?\d{3}/.test(phone.value)) {
		removeErrorMessage('phone');
	} else {
		addErrorMessage('phone', 'Proszę wpisać poprawny numer telefonu.');
		error = true;
	}
	
	// Sprawdź poprawność województwa:
	if (state.selectedIndex != 0) {
		removeErrorMessage('state');
	} else {
		addErrorMessage('state', 'Proszę wybrać województwo.');
		error = true;
	}
	
	// Sprawdź poprawność kodu pocztowego:
	if (/^\d{2}-?\d{3}$/.test(zip.value)) {
		removeErrorMessage('zip');
	} else {
			addErrorMessage('zip', 'Proszę wpisać poprawny kod pocztowy.');
		error = true;
	}

    // Jeśli wystąpił błąd, zapobiegnij akcji domyślnej:
	if (error) {

		// Zapobiegnij akcji domyślnej:
	    if (e.preventDefault) {
	        e.preventDefault();
	    } else {
	        e.returnValue = false;
	    }
	    return false;
    
	}
    
} // Koniec funkcji validateForm().

// Funkcja wywoływana w momencie zmiany opcji.
// Funkcja włącza lub wyłącza przycisk wysyłki.
function toggleSubmit() {
	'use strict';
    
	// Pobierz referencję do przycisku wysyłki:
	var submit = U.$('submit');
	
	// Zmień wartość właściwości disabled:
	if (U.$('terms').checked) {
		submit.disabled = false;
	} else {
		submit.disabled = true;
	}
	
} // Koniec funkcji toggleSubmit().

// Dodaj podstawową funkcjinalność po wczytaniu strony WWW:
window.onload = function() {
    'use strict';

	// Funkcja validateForm() obsługuje wysyłkę formularza:
    U.addEvent(U.$('theForm'), 'submit', validateForm);

	// Wyłącz przycisk wysyłki na początku wypełniania:
	U.$('submit').disabled = true;

	// Sprawdzaj zmiany pola opcji:
    U.addEvent(U.$('terms'), 'change', toggleSubmit);

	// Włącz podpowiedź dla pola numeru telefonu:
	U.enableTooltips('phone');
    
};