// membership.js #2
// Ten skrypt wylicza koszt członkostwa.

// Funkcja wywoływana w momencie wysyłania formularza.
// Funkcja wykonuje obliczenia i zwraca wartość false.
function calculate(e) {
    'use strict';

    // Pobierz obiekt zdarzenia:
    if (typeof e == 'undefined') e = window.event;

    // Zmienna przechowująca łączny koszt:
    var cost;

    // Pobierz referencję do pól formularza:
    var type = U.$('type');
    var years = U.$('years');
    
    // Zamień rok na liczbę:
    if (years && years.value) {
        years = parseInt(years.value);
    }
    
    // Sprawdź poprawność daty:
   if (type && type.value && years && (years > 0) ) {
        
        // Oblicz koszt bazowy:
        switch (type.value) {
            case 'basic':
                cost = 10.00;
                break;
            case 'premium':
                cost = 15.00;
                break;
            case 'gold':
                cost = 20.00;
                break;
            case 'platinum':
                cost = 25.00;
                break;
        } // Koniec instrukcji switch.

        // Weź pod uwagę liczbę lat:
        cost *= years;

        // Zastosuj zniżkę dla składni na więcej niż rok:
        if (years > 1) {
            cost *= .80; // 80%
        }
        
        // Wyświetl łączną kwotę:
        U.$('cost').value = '$' + cost.toFixed(2);
        
    } else { // Wyświetl błąd:
        if (e.type == 'submit') {
           U.$('cost').value = 'Proszę wprowadzić poprawne dane.';
        }
    }

    // Zapobiegnij wysłaniu formularza:
    if (e.preventDefault) {
        e.preventDefault();
    } else {
        e.returnValue = false;
    }
    return false;
        
} // Koniec funkcji calculate().

window.onload = function() {
    'use strict';
    U.addEvent(U.$('theForm'), 'submit', calculate);
    U.addEvent(U.$('type'), 'change', calculate);
    U.addEvent(U.$('years'), 'change', calculate);
};