<?php # getBids.php
// Strona zwraca ofery dotyczące przedmiotu o kwocie wyższej niż zadania.

// Plik konfiguracyjny zawsze musi pojawić się jako pierwszy:
require('../includes/config.inc.php');

// Skrypt zwraca dane w formacie JSON:
header('Content-Type: application/json');

// Do zapamiętania wyników:
$data = array();

// Potrzebne jest itemId i aktualna cena:
if (isset($_GET['itemId']) && filter_var($_GET['itemId'], FILTER_VALIDATE_INT, array('min_range' => 1)) && isset($_GET['currentPrice']) && filter_var($_GET['currentPrice'], FILTER_VALIDATE_FLOAT)) {
	
	// Potrzebne jest połączenie z bazą danych:
	require (MYSQL);
	
	// Potrzebna jest sesja:
	session_start();

	// Jeśli użytkownik jest zalogowany i wybrał strefę czasową,
  // użyj jej do skonwertowania daty i czasu:
	if (isset($_SESSION['timezone'])) {
		$tz = "CONVERT_TZ(dateSubmitted, 'UTC', '{$_SESSION['timezone']}')";
	} else {
		$tz = 'dateSubmitted';
	}
	
	// Zapytanie do bazu danych:
	$q = "SELECT bid, IF($tz > DATE_SUB(UTC_TIMESTAMP(), INTERVAL 24 HOUR), DATE_FORMAT($tz,'%H:%i'), DATE_FORMAT($tz,'%Y-%m-%d @ %H:%i')) AS dateSubmitted FROM bids WHERE itemId={$_GET['itemId']} AND bid>{$_GET['currentPrice']} ORDER BY dateSubmitted ASC";
	$r = mysqli_query ($dbc, $q) or trigger_error("Zapytanie: $q\n<br />Błąd MySQL: " . mysqli_error($dbc));
	
	// Jeśli istnieją wyniki, pobierz je:
	if (@mysqli_num_rows($r) > 0) {
		while ($row = mysqli_fetch_array($r, MYSQLI_ASSOC)) {
			$data[] = $row;
		}
	}
	
	// Czyszczenie:
	mysqli_free_result($r);
	mysqli_close($dbc);
	
} // Koniec walidacji.

// Przekaż dane w formacie JSON:
echo json_encode($data);