// employee.js
// Skrypt tworzy obiekt na podstawie danych z formularza.

// Funkcja wywoływana w momencie wysyłania formularza.
// Funkcja tworzy nowy obiekt.
function process() {
    'use strict';

    // Pobierz referencje do pól formularza:
    var firstName = document.getElementById('firstName').value;
    var lastName = document.getElementById('lastName').value;
    var department = document.getElementById('department').value;

    // Pobierz referencję do elementu wyjściowego:
    var output = document.getElementById('output');

    // Utwórz nowy obiekt:
	var employee = {
	    firstName: firstName,
	    lastName: lastName,
	    department: department,
	    hireDate: new Date()
	}; // Nie zapomnij o średniku!

	console.log(employee);

    // Wyświetl dane w elemencie HTML:
    var message = '<h2>Dodano pracownika</h2>Imię i nazwisko: ' + employee.firstName + ' ' + employee.lastName + '<br>';
    message += 'Dział: ' + employee.department + '<br>';
    message += 'Data zatrudnienia: ' + employee.hireDate.toLocaleDateString();

    // Wyświetl tekst opisujący pracownika:
    output.innerHTML = message;

  // Zwróć false, by zapobiec wysłaniu formularza:
  return false;

} // Koniec funkcji process().

// Konfiguracja początkowa:
function init() {
    'use strict';
    document.getElementById('theForm').onsubmit = process;
} // Koniec funkcji init().
window.onload = init;
