// view.js
// Skrypt wykorzystuje Ajax do dynamicznej obsługi wysyłania formularza zgłoszenia oferty.
// Ajax służy również do pobrania najnowszej oferty.

// Otocz wszystko natychmiast wykonywaną funkcją:
(function() {
    'use strict';
    
    // Te zmienne wykorzystują domknięcie, by były dostępne w pozostałych funkcjach:
    var bidAjax = null;
    var getBidsAjax = U.getXMLHttpRequestObject();
    var messageDiv = null;
    
    // Funkcja używana do wyświetlenia komunikatu:
	function showMessage(message, messageClass) {
    
	    // Pobierz referencję do DIV:
	    if (!messageDiv) {
	        messageDiv = U.$('messageDiv');
	    }
        
		// Jeśli DIV nie istnieje, utwórz go:
		if (!messageDiv) {
		    messageDiv = document.createElement('div');
		    messageDiv.id = 'messageDiv';
		    var itemHeading = U.$('itemHeading');
		    itemHeading.parentNode.insertBefore(messageDiv, itemHeading);
		} // Koniec warunku messageDiv.
        
        // Uaktualnij element DIV:
	    messageDiv.className = messageClass;
	    messageDiv.innerHTML = message;

	} // Koniec funkcji showMessage().

    // Funkcja wywoływana po uzyskaniu odpowiedzi dla bidAjax:
	function handleBidAjaxResponse() {

	    // Sprawdź readyState:
	    if (bidAjax.readyState == 4) {

	        // Sprawdź kod statusu:
	        if ( (bidAjax.status >= 200 && bidAjax.status < 300) 
	        || (bidAjax.status == 304) ) {
                
                // Przetwórz odpowiedź:
				var bidResponse = JSON.parse(bidAjax.responseText);

				// Sprawdź odpowiedź:
				if (bidResponse.status == 'zaakceptowano') {
    
				    // Wyświetl komunikat:
				    showMessage(bidResponse.message, 'good');

				    // Pobierz oferty:
				    getBids();
    
				} else { // Błąd!
				    // Wyświetl błąd:
				    showMessage(bidResponse.message, 'error');
				}
                
	        } else { // Zły status, wyślij formularz w sposób tradycyjny:
	            U.$('bidForm').submit();
	        }

	    } // Koniec warunku readyState.
    
	} // Koniec funkcji handleBidAjaxResponse().

    // Funkcja wywoływana w momencie róby wysyłki oferty.
    // Funkcja waliduje dane i przeprowadza żądanie Ajax.
	function submitBid(e) {

	    // Pobierz obiekt zdarzenia:
	    if (typeof e == 'undefined') e = window.event;

	    // Zapobiegnij zdarzeniu domyślnemu:
	    if (e.preventDefault) {
	        e.preventDefault();
	    } else {
	        e.returnValue = false;
	    }

        // Pobierz referencję do elementu formularza:
		var bid = U.$('bid').value;

		// Upewnij się, że bid jest większe od currentPrice:
		if (bid > currentPrice) {
            
            // Utwórz obiekt Ajax, jeśli jeszcze nie powstał:
			if (!bidAjax) {
			    bidAjax = U.getXMLHttpRequestObject();
			    bidAjax.onreadystatechange = handleBidAjaxResponse;
			}       

            //Wykonaj żądanie Ajax:
			bidAjax.open('GET', 'ajax/bid.php?bid=' + bid + '&itemId=' + itemId + '&currentPrice=' + currentPrice, true);
			bidAjax.send(null); 
    
	    } else {
	        showMessage('Oferta musi być większa od $' + currentPrice.toFixed(2) + '.', 'error');
	    }

	    return false;

	} // Koniec funkcji submitBid().

    // Funkcja wywoływana w momencie obsługi odpowiedzi getBidsAjax:
	function handleGetBidsAjaxResponse() {
    
	    // Sprawdź readyState:
	    if (getBidsAjax.readyState == 4) {

	        // Sprawdź kod statusu:
	        if ( (getBidsAjax.status >= 200 && getBidsAjax.status < 300) 
	        || (getBidsAjax.status == 304) ) {

                // Przetwórz odpowiedź:
				var bids = JSON.parse(getBidsAjax.responseText);

				// Jeśli zwrócono dane, uaktualnij tabelę:
				if (bids.length > 0) {
                    
                    // Uakatualnij cenę na najwyższą ofertę:
					currentPrice = parseFloat(bids[bids.length-1].bid).toFixed(2);

					// Uaktualnij currentSpan i ukryte pole formularza:
					U.setText('currentSpan', currentPrice.toString());
					U.setText('currentHidden', currentPrice.toString());
                    
                    // Pobierz referencję do tabeli:
					var tb = U.$('tableBody');

					// Przejdź przez dane w pętli:
					for (var i = 0, count = bids.length; i < count; i++) {
    
					    // Utwórz nowy wiersz tabeli z dwiema komórkami:
					    var tr = document.createElement('tr');
					    var td1 = document.createElement('td');
					    var td2 = document.createElement('td');
    
					    // Dodaj tekst:
					    td1.appendChild(document.createTextNode('$' + bids[i].bid));
					    td2.appendChild(document.createTextNode(bids[i].dateSubmitted));
    
					    // Dodaj komórki do wiersza:
					    tr.appendChild(td1);
					    tr.appendChild(td2);
    
					    // Dodaj wiersz jako drugi wiersz w tabeli:
					    var trs = document.getElementsByTagName('tr');
					    tb.insertBefore(tr, trs[1]);
    
					} // Koniec pętli FOR.
               
	            } // Koniec warunku bids.length.

	        } // Koniec warunku status.

	    } // Koniec warunku readyState.
   
	} // Koniec funkcji handleGetBidsAjaxResponse().
    
    // Funkcja, która pobiera zaktualizowaną ofertę:
	function getBids() {
	    getBidsAjax.open('GET', 'ajax/getBids.php?currentPrice=' + currentPrice + '&itemId=' + itemId, true);
	    getBidsAjax.send(null); 
	}

    // Funkcja wywoływana w momencie wczytania kodu strony WWW.
    // Funkcja dodaje procedurę obsługi wysyłki formularza.
    // Dodatkowo funkcja przygotowuje obiekt getBidsAjax.
	function init() {
    
	    // Ukryj komunikat dotyczący odświeżania, ponieważ jest wykonywane przez kod JavaScript:
	    U.$('refreshMessage').style.display = 'none';

	    // Dodaj obsługę wysyłki formularza:
	    U.addEvent(U.$('bidForm'), 'submit', submitBid);
    
	    // Ustaw obiekt dotyczący komunikacji Ajax:
	    getBidsAjax.onreadystatechange = handleGetBidsAjaxResponse;
    
        // Utwórz nowy "minutnik", który będzie co 10 sekund pobierał nowe oferty:
		var getBidsTimer = setInterval(getBids, 10000);
        
        // Jeśli aukcja kończy się za mniej niż godzinę, pokaż dokładny czas:
		if (minutesRemaining < 60) { // Pokaż licznik.

		    // Pobierz element span:
		    var span = U.$('minutesRemainingSpan');

		    // Utwórz odmierzanie czasu:
		    var closingTimer = setInterval(function() {
                
                // O minutę mniej:
				minutesRemaining--;

				if (minutesRemaining > 0) {

				    // Uaktualnij element span:
				    U.setText('minutesRemainingSpan', 'pozostało ' + minutesRemaining + ' minut');

				} else { // Koniec aukcji!

				    // Zatrzymaj oba "minutniki":
				    clearInterval(closingTimer);
				    clearInterval(getBidsTimer);
    
				    // Wyczyść obiekt Ajax:
				    bidAjax = null;
				    getBidsAjax = null;
    
				    // Usuń procedurę obsługi formularza:
				    U.removeEvent(U.$('bidForm'), 'submit', submitBid);

				    // Usuń formularz zgłaszania oferty:
				    var bidForm = U.$('bidForm');
				    bidForm.parentNode.removeChild(bidForm);
    
				    // Usuń element span:
				    span.parentNode.removeChild(span);

				    // Wstaw komunikat:
				    showMessage('Aukcja została zakończona.', 'error');

				}               
                
	        }, 60000);
    
	    } // Koniec warunku minutesRemaining.
    
	} // Koniec funkcji init().    

	// Przypisz procedurę obsługi zdarzenia wczytania strony WWW:
	U.addEvent(window, 'load', init);

})(); // Koniec funkcji wywoływanej natychmiast.