<?php # config.inc.php
/* Ten skrypt:
 * - definiuje stałe i ustawienia
 * - określa sposób obsługi błędów
 * - definiuje przydatne funkcje
 */
 
// Wskaż kto i kiedy tworzył tę witrynę.


// ********************************** //
// ************ USTAWIENIA ************ //

// Określ miejsce działania witryny:
define('LIVE', FALSE);

// Addres kontaktowy do administratora:
define('EMAIL', 'WpiszPrawdziwyAdres');

// Adres URL witryny (wykorzystywany w przekierowaniach):
define ('BASE_URL', 'http://localhost/');

// Lokalizacja skryptu połączenia MySQL:
define ('MYSQL', '../mysqli_connect.php');

// Określ strefę czasową dla PHP 5.1 lub nowszego:
date_default_timezone_set ('Europe/Warsaw');

// ************ USTAWIENIA ************ //
// ********************************** //


// ****************************************** //
// ************ OBSŁUGA BŁĘDÓW ************ //

// Procedura obsługi błędów:
function my_error_handler ($e_number, $e_message, $e_file, $e_line, $e_vars) {

	// Skonstruuuj komunikat o błędzie:
	$message = "Wystąpił błąd w pliku '$e_file' w wierszu $e_line: $e_message\n";
	
	// Dodaj datę i czas:
	$message .= "Data i czas: " . date('n-j-Y H:i:s') . "\n";
	
	if (!LIVE) { // Etap programowania (wyświetl błąd).

		// Wyświetl błąd:
		echo '<div class="error">' . nl2br($message);
	
		// Dodaj zmienne i stos wywołań:
		echo '<pre>' . print_r ($e_vars, 1) . "\n";
		debug_print_backtrace();
		echo '</pre></div>';
		
	} else { // Nie pokazuj błędu:

		// Wyślij błąd do administratora:
		$body = $message . "\n" . print_r ($e_vars, 1);
		mail(EMAIL, 'Błąd na witrynie!', $body, 'From: email@przyklad.pl');
	
		// Wyświetl komunikat tylko wtedy, gdy nie jest typu E_NOTICE:
		if ($e_number != E_NOTICE) {
			echo '<div class="error"Wystąpił błąd systemu. Przepraszamy za niedogodności.</div><br />';
		}
	} // Koniec warunku dotyczącego !LIVE.

} // Koniec definicji my_error_handler().

// Użyj nowej obsługi błędów:
set_error_handler ('my_error_handler');

// ************ OBSŁUGA BŁĘDÓW ************ //
// ****************************************** //