// events.js

// Funkcja wywoływana w momencie zajścia zdarzenia.
// Funkcja zgłasza typ zdarzenie i miejsce jego zajścia.
function reportEvent(e) {
    'use strict';

    // Pobierz obiekt zdarzenia:
    if (typeof e == 'undefined') e = window.event;

    // Pobierz cel zdarzenia:
    var target = e.target || e.srcElement;
    
    // Określ komunikat do wyświetlenia:
    var msg = target.nodeName + ': ' + e.type + '\n';
    
    // Dodaj komunikat do obszaru tekstowego:
    U.$('output').value += msg;
    
} //Koniec funkcji reportEvent().

// Funkcja wywoływana w momencie wysyłki formularza.
// Dodaje i usuwa procedury obsługi zdarzeń,
// I dodatkowo zwraca false, by anulować wysyłkę formularza.
function setHandlers() {
    'use strict';

    // Lista możliwych zdarzeń:
    var events = ['mouseover', 'mouseout', 'click', 'keypress', 'blur'];
    
    // Odpowiednio dodaj lub usuń procedurę obsługi:
    for (var i = 0, count = events.length; i < count; i++) {
        var checkbox = U.$(events[i]); // Pobierz element.
        if (checkbox.checked) { // Czy jest zaznaczony?
            U.addEvent(document, events[i], reportEvent);
        } else {
            U.removeEvent(document, events[i], reportEvent);
        }
    } // Koniec pętli FOR.
    
    // Wyczyść obszar tekstowy:
    U.$('output').value = '';
    
    // Zwróć wartość false, aby zapobiec wysyłce:
    return false;
    
} // Koniec funkcji setHandlers().

// Włącz niezbędną funkcjonalność początkową:
window.onload = function() {
    'use strict';
    U.$('theForm').onsubmit = setHandlers;
};