// event.js
// Skrypt sprawdza poprawność dwóch dat i wylicza różnicę między nimi (w dniach).

// Funkcja wywoływana w momencie wysyłania formularza.
// Funkcja przetwarza daty i zwraca wartość false.
function process() {
    'use strict';

    // Pobierz referencje do elementów formularza:
    var start = document.getElementById('start');
    var end = document.getElementById('end');

    // Pobierz referencję do akapitu:
    var output = document.getElementById('output');

    // Dane do wyświetlenia:
    var message = '';
    var interval = '';
    var day = 1000 * 60 * 60 *24;

    // Sprawdź, czy wprowadzone daty są poprawne!

    // Try to create a start and end date:
    var startDate = new Date(start.value);
    var endDate = new Date(end.value);
    if ( startDate.getTime() && endDate.getTime() ) {

        // Upewnij się, że data początu jest mniejsza:
        if (startDate < endDate) {

            // Określ różnicę:
var diff = endDate - startDate;

// Przetwórz różnicę:
if (diff <= day) {
    interval = '1 dzień';
} else {
    interval = Math.round(diff/day) + ' dni';
}

            // Zbuduj komunikat:
            message = 'Zdarzenie zostało zaplanowane. Rozpoczyna się ' + startDate.toLocaleDateString();
            message += ' a kończy ' + endDate.toLocaleDateString();
            message += ', co oznacza ' + interval + '.';

        } else { // Data początkowa nie jest mniejsza!
            message = 'Data początku nie może być większa od daty zakończenia!';
        }

    } else { // Jedna lub obie daty są nieprawidłowe!
        message = 'Prosze wprowadzić poprawną datę w formacie RRRR/MM/DD.';
    }

    // Uaktualnij akapit:
	if (output.textContent !== undefined) {
		output.textContent = message;
	} else {
		output.innerText = message;
	}

  // Zwróć false, by zapobiec wysłaniu formularza:
  return false;

} // Koniec funkcji process().

// Konfiguracja początkowa:
function init() {
    'use strict';
    document.getElementById('theForm').onsubmit = process;
} // Koniec funkcji init().
window.onload = init;