# How to contribute
We welcome contributions from the community and are pleased to have them.  Please follow this guide when logging issues or making code changes.

## Logging Issues
All issues should be created using the [new issue form](https://github.com/spumko/joi/issues/new).  Clearly describe the issue including steps to reproduce if there are any.  Also, make sure to indicate the earliest version that has the issue being reported.

## Patching Code
Code changes are welcome and should follow the guidelines below.

* Fork the repository on GitHub.
* Fix the issue ensuring that your code follows the [style guide](https://github.com/spumko/hapi/blob/master/docs/Style.md).
* Add tests for your new code ensuring that you have 100% code coverage (we can help you reach 100% but will not merge without it).
    * Run `npm test` to generate a report of test coverage
* [Pull requests](http://help.github.com/send-pull-requests/) should be made to the [master branch](https://github.com/spumko/joi/tree/master).