var cluster = require('cluster');
var numCPUs = require('os').cpus().length;
var express = require('express');

if (cluster.isMaster) {
  console.log ('Wydzielanie %s wątków roboczych z wątku głównego', numCPUs);
  for (var i = 0; i < numCPUs; i++) {
    cluster.fork();
  }
  cluster.on('online', function(worker) {
    console.log ('wątek roboczy działający w procesie o numerze pid %s', worker.process.pid);
  });
  cluster.on('exit', function(worker, code, signal) {
    console.log('wątek roboczy działający w procesie o numerze pid %s jest zamknięty', worker.process.pid );
  });
} else if (cluster.isWorker) {
  var port = 3000;
  console.log('wątek roboczy (%s) nasłuchuje pod adresem http://localhost:%s', cluster.worker.process.pid, port);
  var app = express();
  app.get('*', function(req, res) {
    res.send(200, 'cluster ' + cluster.worker.process.pid + ' odpowiedział \n');
  });
  app.listen(port);
}
