var mongoose = require('mongoose');
var db = mongoose.connect('mongodb://localhost/words');
var wordSchema = require('./word_schema.js').wordSchema;
var Words = mongoose.model('Words', wordSchema);
setTimeout(function(){
  mongoose.disconnect();
}, 3000);
mongoose.connection.once('open', function(){
  var query = Words.count().where('first').in(['a', 'e', 'i', 'o', 'u']);
  query.where('last').in(['a', 'e', 'i', 'o', 'u']);
  query.exec(function(err, count){
    console.log("\nLiczba wyrazów rozpoczynających się i kończących samogłoską: " + count);
  });
  query.find().limit(5).sort({size:-1});
  query.exec(function(err, docs){
    console.log("\nPięć najdłuższych wyrazów rozpoczynających się i kończących samogłoską: ");
    for (var i in docs){
      console.log(docs[i].word);
    }
  });
  query = Words.find();
  query.mod('size',2,0);
  query.where('size').gt(6);
  query.limit(10);
  query.select({word:1, size:1});
  query.exec(function(err, docs){
    console.log("\nWyrazy o równej długości, które liczą więcej niż 5 liter: ");
    for (var i in docs){
      console.log(JSON.stringify(docs[i]));
    }
  });
});