var MongoClient = require('mongodb').MongoClient;
MongoClient.connect("mongodb://localhost/", function(err, db) {
  var myDB = db.db("words");
  myDB.collection("word_stats", countItems);
  setTimeout(function(){
    db.close();
  }, 3000);
});
function countItems(err, words){
  words.count({first:{$in: ['a', 'b', 'c']}}, function(err, count){
    console.log("Wyrazy rozpoczynające się od liter a, b lub c: " + count);
  });
  words.count({size:{$gt: 12}}, function(err, count){
    console.log("Wyrazy liczące więcej niż 12 znaków: " + count);
  });
  words.count({size:{$mod: [2,0]}}, function(err, count){
    console.log("Wyrazy z parzystą liczbą liter: " + count);
  });
  words.count({letters:{$size: 12}}, function(err, count){
    console.log("Wyrazy z 12 różnymi znakami: " + count);
  });
  words.count({$and: [{first:{$in: ['a', 'e', 'i', 'o', 'u']}},
                     {last:{$in: ['a', 'e', 'i', 'o', 'u']}}]}, 
             function(err, count){
    console.log("Wyrazy rozpoczynające lub kończące się samogłoską: " + count);
  });
  words.count({"stats.vowels":{$gt:6}}, function(err, count){
    console.log("Wyrazy zawierające co najmniej 7 samogłosek: " + count);
  });
  words.count({letters:{$all: ['a','e','i','o','u']}}, 
              function(err, count){
    console.log("Wyrazy z wszystkimi pięcioma samogłoskami: " + count);
  });
  words.count({otherChars: {$exists:true}}, function(err, count){
    console.log("Wyrazy ze znakami spoza alfabetu: " + count);
  });
  words.count({charsets:{$elemMatch:{$and:[{type:'other'},
              {chars:{$size:2}}]}}}, 
              function(err, count){
    console.log("Wyrazy z dwoma znakami spoza alfabetu: " + count);
  });
}