var mongoose = require('mongoose'),
    Customer = mongoose.model('Customer'),
    Address = mongoose.model('Address'),
    Billing = mongoose.model('Billing');
exports.getCustomer = function(req, res) {
  Customer.findOne({ userid: 'customerA' })
  .exec(function(err, customer) {
    if (!customer){
      res.json(404, {msg: 'Nie znaleziono klienta.'});
    } else {
      res.json(customer);
    }
  });
};
exports.updateShipping = function(req, res){
  var newShipping = new Address(req.body.updatedShipping);
  Customer.update({ userid: 'customerA' }, 
      {$set:{shipping:[newShipping.toObject()]}})
  .exec(function(err, results){
    if (err || results < 1){
     res.json(404, {msg: 'Nie powiodła się aktualizacja danych wysyłki do klienta.'});
    } else {
     res.json({msg: "Zaktualizowano dane wysyłki do klienta"});
    }
  });
};
exports.updateBilling = function(req, res){
  // W tym miejscu możesz zweryfikować informacje o karcie kredytowej
  // i wstrzymać proces płacenia, jeśli okaże się ona nieprawidłowa. 
  var newBilling = new Billing(req.body.updatedBilling);
  Customer.update({ userid: 'customerA' }, 
      {$set:{billing:[newBilling.toObject()]}})
  .exec(function(err, results){
    if (err || results < 1){
     res.json(404, {msg: 'Nie powiodła się aktualizacja danych rachunku.'});
    } else {
     res.json({msg: "Zaktualizowano dane rachunku klienta"});
    }
  });
};
exports.updateCart = function(req, res){
  Customer.update({ userid: 'customerA' }, 
      {$set:{cart:req.body.updatedCart}})
  .exec(function(err, results){
    if (err || results < 1){
     res.json(404, {msg: 'Nie powiodła się aktualizacja koszyka.'});
    } else {
     res.json({msg: "Zaktualizowano koszyk klienta"});
    }
  });
};
