var MongoClient = require('mongodb').MongoClient;
MongoClient.connect("mongodb://localhost/", function(err, db) {
  var myDB = db.db("words");
  myDB.collection("word_stats", findItems);
  setTimeout(function(){
    db.close();
  }, 3000);
});
function displayWords(msg, cursor, pretty){
  cursor.toArray(function(err, itemArr){
    console.log("\n"+msg);
    var wordList = [];
    for(var i=0; i<itemArr.length; i++){
      wordList.push(itemArr[i].word);
    }
    console.log(JSON.stringify(wordList, null, pretty));
  });
}
function findItems(err, words){
  words.find({first:{$in: ['a', 'b', 'c']}}, function(err, cursor){
    displayWords("Wyrazy rozpoczynające się od liter a, b lub c: ", cursor);
  });
  words.find({size:{$gt: 12}}, function(err, cursor){
    displayWords("Wyrazy liczące więcej niż 12 znaków: ", cursor);
  });
  words.find({size:{$mod: [2,0]}}, function(err, cursor){
    displayWords("Wyrazy z parzystą liczbą liter: ", cursor);
  });
  words.find({letters:{$size: 12}}, function(err, cursor){
    displayWords("Wyrazy z 12 różnymi znakami: ", cursor);
  });
  words.find({$and: [{first:{$in: ['a', 'e', 'i', 'o', 'u']}},
                     {last:{$in: ['a', 'e', 'i', 'o', 'u']}}]}, 
             function(err, cursor){
    displayWords("Wyrazy rozpoczynające lub kończące się samogłoską: ", cursor);
  });
  words.find({"stats.vowels":{$gt:6}}, function(err, cursor){
    displayWords("Wyrazy zawierające co najmniej 7 samogłosek: ", cursor);
  });
  words.find({letters:{$all: ['a','e','i','o','u']}}, 
             function(err, cursor){
    displayWords("Wyrazy z wszystkimi pięcioma samogłoskami: ", cursor);
  });
  words.find({otherChars: {$exists:true}}, function(err, cursor){
    displayWords("Wyrazy ze znakami spoza alfabetu: ", cursor);
  });
  words.find({charsets:{$elemMatch:{$and:[{type:'other'},
                                          {chars:{$size:2}}]}}}, 
             function(err, cursor){
    displayWords("Wyrazy z dwoma znakami spoza alfabetu: ", cursor);
  });
}