var MongoClient = require('mongodb').MongoClient;
MongoClient.connect("mongodb://localhost/", function(err, db) {
  var myDB = db.db("words");
  myDB.collection("word_stats", groupItems);
  setTimeout(function(){
    db.close();
  }, 3000);
});
function groupItems(err, words){
  words.group(['first','last'], 
              {first:'o',last:{$in:['a','e','i','o','u']}},
              {"count":0}, 
              function (obj, prev) { prev.count++; }, true,
              function(err, results){
        console.log("\nWyrazy z literą o jako pierwszą, zakończone samogłoską," +
                    " grupowane według pierwszej i ostatniej litery: ");
        console.log(results);
  });
  words.group(['first'],
              {size:{$gt:13}},
              {"count":0, "totalVowels":0},
              function (obj, prev) { 
                prev.count++; prev.totalVowels += obj.stats.vowels;
              }, {}, true, 
              function(err, results){
    console.log("\nWyrazy grupowane według pierwszej litery, które liczą więcej niż 13 liter: ");
    console.log(results);
  });
  words.group(['first'],{}, {"count":0, "vowels":0, "consonants":0}, 
              function (obj, prev) { 
                prev.count++;
                prev.vowels += obj.stats.vowels;
                prev.consonants += obj.stats.consonants;
              },function(obj){
                obj.total = obj.vowels + obj.consonants;
              }, true, 
              function(err, results){
        console.log("\nWyrazy grupowane według pierwszej litery z sumami liter: ");
        console.log(results);
  });
}