﻿using System;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using Should;
using WebApiBook.IssueTrackerApi.Models;
using Xbehave;

namespace WebApiBook.IssueTrackerApp.AcceptanceTests.Features
{
    public class DeletingIssues : IssuesFeature
    {
        private readonly Uri _uriIssue = new Uri("http://localhost/issue/1");

        [Scenario]
        public void DeletingAnIssue(Issue fakeIssue)
        {
            "Mając istniejące zgłoszenie błędu".
                f(() =>
                {
                    fakeIssue = FakeIssues.FirstOrDefault();
                    MockIssueStore.Setup(i => i.FindAsync("1")).Returns(Task.FromResult(fakeIssue));
                    MockIssueStore.Setup(i => i.DeleteAsync("1")).Returns(Task.FromResult(""));
                });
            "Kiedy żądanie DELETE zostanie wykonane".
                f(() =>
                {
                    Request.RequestUri = _uriIssue;
                    Request.Method = HttpMethod.Delete;
                    Response = Client.SendAsync(Request).Result;
                });
            "Wtedy zgłoszenie błędu powinno być usunięte".
                f(() => MockIssueStore.Verify(i => i.DeleteAsync("1")));
            "Wtedy będzie zwrócony kod stanu '200 OK'' is returned".
                f(() => Response.StatusCode.ShouldEqual(HttpStatusCode.OK));
        }

        [Scenario]
        public void DeletingAnIssueThatDoesNotExist()
        {
            "Mając nieistniejące zgłoszenie błędu".
                f(() => MockIssueStore.Setup(i => i.FindAsync("1")).Returns(Task.FromResult((Issue) null)));
            "Kiedy żądanie DELETE zostanie wykonane".
                f(() =>
                {
                    Request.RequestUri = _uriIssue;
                    Request.Method = HttpMethod.Delete;
                    Response = Client.SendAsync(Request).Result;
                });
            "Wtedy będzie zwrócony kod stanu '404 Not Found'".
                f(() => Response.StatusCode.ShouldEqual(HttpStatusCode.NotFound));
        }
    }
}
