using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Azure.Documents;
using Microsoft.Azure.Documents.Client;
using Microsoft.Azure.Documents.Linq;
using Microsoft.Azure.WebJobs;

namespace WJTest
{
    public class Functions
    {
        public static void ProcessTimerAction([TimerTrigger("0 0 0 * * 1", RunOnStartup = true)]TimerInfo timerInfo)
        {
            var url = "https://r-9.documents.azure.com:443/";
            var key = "A8rVTLZwfuD5wTMVoXNacrWl9FBaP532c5kZj6R4gdQQMwcaYHRcAMj37KK4qe6DKG8NasGuSRQMVWWkRnjMSg==";
            var _databaseName = "SorageDataHistory";
            var _orderCollectionName = "UploadedFile";
            CultureInfo myCI = new CultureInfo("en-US");

            SqlConnectionStringBuilder builder = new SqlConnectionStringBuilder();
            builder.DataSource = "rozdzaildziewiaty.database.windows.net";
            builder.UserID = "userId";
            builder.Password = "Password";
            builder.InitialCatalog = "RIX";

            Calendar myCal = myCI.Calendar;
            CalendarWeekRule myCWR = myCI.DateTimeFormat.CalendarWeekRule;
            DayOfWeek myFirstDOW = myCI.DateTimeFormat.FirstDayOfWeek;
            var weekNumber = myCal.GetWeekOfYear(DateTime.Now, myCWR, myFirstDOW);

            var result = QueryAllDocument(url, key, _databaseName, _orderCollectionName);
            result.GroupBy(g => g.SenderId);

            var groupedList = from item in result
                              group item by new { item.SenderId}
                              into newGroup
                              select new
                              {
                                  SenderId = newGroup.Key.SenderId,
                                  Count = newGroup.Count(),
                              };

            using (SqlConnection connection = new SqlConnection(builder.ConnectionString))
            {
                connection.Open();
                foreach (var item in groupedList)
                {
                    StringBuilder sb = new StringBuilder();
                    sb.Append($"INSERT INTO dbo.Resources (UserId, NumberOfWeek, NumberOfFile) VALUES({item.SenderId}, {weekNumber}, {item.Count});");
                    String sql = sb.ToString();
                    using (SqlCommand command = new SqlCommand(sql, connection))
                    {
                        var reader = command.ExecuteReader();
                        reader.Close();
                    }
                }
            }
        }

        public static List<ResorceDTO> QueryAllDocument(string Uri, string Key, string DatabaseName, string CollectionName)
        {
            var option = new FeedOptions { EnableCrossPartitionQuery = true };
            DocumentClient client = new DocumentClient(new Uri(Uri), Key, new ConnectionPolicy { EnableEndpointDiscovery = false });
            List<ResorceDTO> list = client.CreateDocumentQuery<ResorceDTO>(UriFactory.CreateDocumentCollectionUri(DatabaseName, CollectionName), option).Where(s => s.SendedTime > DateTime.Now.AddDays(-7)).ToList();
            return list;
        }
    }
}

public class ResorceDTO
{
    public string Id { get; set; }
    public int SenderId { get; set; }
    public string FileName { get; set; }
    public DateTime SendedTime { get; set; }
}
