﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using SDBWebAPI.Models;
using SDBWebAPI.ModelsDTO;
using SDBWebAPI.Services.Interfaces;

namespace SDBWebAPI.Controllers
{
    [Produces("application/json")]
    public class RoleController : Controller
    {
        private readonly IRoleService roleService;

        public RoleController(IRoleService roleService)
        {
            this.roleService = roleService;
        }

        [Route("api/role/getAllRoles")]
        [HttpGet]
        public RolesDTO GetAllUsers()
        {
            return roleService.GetAllRoles();
        }

        [Route("api/role/addRole")]
        [HttpPost]
        public ResponseDTO AddRole(Role role)
        {
            return roleService.Add(role);
        }
    }
}