﻿using BCFinanceCorpoAPI.Extensions.Enums;
using BCFinanceCorpoAPI.Models;
using BCFinanceCorpoAPI.ModelsDTO;
using BCFinanceCorpoAPI.Services.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Transactions;

namespace BCFinanceCorpoAPI.Services.Implementation
{
    public class TransactionService : ITransactionService
    {
        private readonly FCBlockchainContext context;
        private readonly IBlockchainService blockchainService;

        public TransactionService(FCBlockchainContext context, IBlockchainService blockchainService)
        {
            this.blockchainService = blockchainService;
            this.context = context;
        }

        public TransactionsWirhObjectsListDTO GetTransactionsByUsersId(int userId, TransactionType transactionType)
        {
            TransactionsDTO transactions = new TransactionsDTO() { TransactionList = new List<Transactions>() };

            if (transactionType == TransactionType.Send)
            {
                transactions.TransactionList = context.Transactions.Where(t => t.Sender == userId).ToList();
            }
            else
            {
                transactions.TransactionList = context.Transactions.Where(t => t.Receiver == userId).ToList();
            }

            TransactionsWirhObjectsListDTO fullTransactionsList = new TransactionsWirhObjectsListDTO() { TransactionsList = new List<TransactionsWirhObjectsDTO>() };

            foreach (Transactions tran in transactions.TransactionList)
            {
                var fulltransaction = new TransactionsWirhObjectsDTO()
                {
                    Data = tran.Data,
                    ReceiveAddress = tran.ReceiveAddress,
                    ReceiveObject = blockchainService.GetSmartContractByAddress(tran.ReceiveAddress),
                    Receiver = tran.Receiver,
                    SendAddress = tran.SendAddress,
                    SendObject = blockchainService.GetSmartContractByAddress(tran.SendAddress),
                    Sender = tran.Sender
                };

                fullTransactionsList.TransactionsList.Add(fulltransaction);
            }

            return fullTransactionsList;
        }

        public ResponseDTO SendTransaction(int firstUserId, int secondUserId, object sendObject, TransactionType transactionType, int transactionId)
        {
            if (transactionType == TransactionType.Send)
            {
                var response = blockchainService.SendSmartContract(sendObject);

                if (response.Result.Code == "400")
                    return response.Result;

                Transactions transaction = new Transactions()
                {
                    Data = DateTime.Now,
                    Sender = firstUserId,
                    Receiver = secondUserId,
                    SendAddress = response.Result.ResponseObject
                };

                try
                {
                    context.Add(transaction);
                    context.SaveChanges();
                }
                catch (Exception exception)
                {
                    return new ResponseDTO() { Code = "400", Message = $"Failed during add Transaction object to db, error message: {exception.Message}", Status = "Failed" };
                }

                return new ResponseDTO() { Code = "200", Message = "Added transaction object to db", Status = "Success" };

            }
            else
            {
                var response = blockchainService.SendSmartContract(sendObject);

                if (response.Result.Code == "400")
                    return response.Result;

                var transactionToModify = context.Transactions.Where(t => t.Id == transactionId).SingleOrDefault();

                if (transactionToModify == null)
                    return new ResponseDTO() { Code = "400", Message = $"Transaction about id: {transactionId} doesn't exist", Status = "Failed" };

                transactionToModify.ReceiveAddress = response.Result.ResponseObject;

                try
                {
                    context.Update(transactionToModify);
                }
                catch (Exception exception)
                {
                    return new ResponseDTO() { Code = "400", Message = $"Failed during add Transaction object to db, error message: {exception.Message}", Status = "Failed" };
                }

                return new ResponseDTO() { Code = "200", Message = "Added transaction object to db", Status = "Success" };
            }
        }
    }
}
