﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using BCFinanceCorpoAPI.Models;
using BCFinanceCorpoAPI.ModelsDTO;
using BCFinanceCorpoAPI.Services.Interface;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace BCFinanceCorpoAPI.Controllers
{
    public class UserController : Controller
    {
        private readonly IUserService userService;

        public UserController(IUserService userService)
        {
            this.userService = userService;
        }

        [Route("api/User/getAll")]
        [HttpGet]
        public UsersDTO GetAll()
        {
            return userService.GetAll();
        }

        [Route("api/User/login")]
        [HttpGet]
        public ResponseDTO Login(string mail, string password)
        {
            return userService.Login(mail, password);
        }

        [Route("api/User/register")]
        [HttpPost]
        public ResponseDTO Register(Users user)
        {
            return userService.Register(user);
        }
    }
}