import { Component, OnInit } from '@angular/core';
import { StatisticService } from '../statistic.service';
import { IBestUsers } from '../ibest-users';
import { IBestUser } from '../ibest-user';
import * as CanvasJS from './../canvasjs.min.js';

@Component({
  selector: 'app-best-user',
  templateUrl: './best-user.component.html',
  styleUrls: ['./best-user.component.css']
})
export class BestUserComponent implements OnInit {

  constructor(private statisticService: StatisticService) { }
  
  result: IBestUsers = { bestUsers  : Array<IBestUser>()};

  ngOnInit() {
    this.initCharts();
  }

  compareDataPointYDescend(dataPoint1, dataPoint2) {
    return dataPoint2.y - dataPoint1.y;
}

 async initCharts () {
  this.result.bestUsers =  await this.statisticService.getBestUser();
  const dps = [];

  for (const i of this.result.bestUsers) {
    dps.push({
      label: i.username,
      y: i.result
  });
}

const dps2 = dps.sort();

  const chart = new CanvasJS.Chart('chartContainer', {
    animationEnabled: true,
    theme: 'light2', 
    title: {
      text: 'Najlepszy pracownik'
    },
    axisY: {
      title: 'Współczynnik sprzedarzy'
    },
    axisX: {
      interval: 1
    },
    data: [{
      type: 'column',
      showInLegend: true,
      legendMarkerColor: 'grey',
      dataPoints: dps2
    }]
  });

  chart.options.data[0].dataPoints.sort(this.compareDataPointYDescend);
  chart.render();
  }

}
