/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { makeParamDecorator } from '../util/decorators';
var ɵ0 = function (token) { return ({ token: token }); };
/**
 * Inject decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Inject = makeParamDecorator('Inject', ɵ0);
/**
 * Optional decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Optional = makeParamDecorator('Optional');
/**
 * Self decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Self = makeParamDecorator('Self');
/**
 * SkipSelf decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var SkipSelf = makeParamDecorator('SkipSelf');
/**
 * Host decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Host = makeParamDecorator('Host');
var ɵ1 = function (attributeName) { return ({ attributeName: attributeName }); };
/**
 * Attribute decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Attribute = makeParamDecorator('Attribute', ɵ1);
export { ɵ0, ɵ1 };
//# sourceMappingURL=data:application/json;base64,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