import { Component, OnInit } from '@angular/core';
import { TouchSequence } from 'selenium-webdriver';
import { Router } from '@angular/router';
import { CookieService } from 'ngx-cookie-service';
import { ToastrService } from 'ngx-toastr';
import { LoginServiceService } from '../Services/login.service';

@Component({
  selector: 'app-main-page',
  templateUrl: './main-page.component.html',
  styleUrls: ['./main-page.component.css']
})
export class MainPageComponent implements OnInit {

  selectedComponent = 'Home';
  isAdmin = '';

  constructor(private loginServiceService: LoginServiceService,
              public router: Router,
              private cookieService: CookieService,
              private toastr: ToastrService) { }

  ngOnInit() {
    this.isAdmin = this.cookieService.get( 'isAdmin');
  }

  componentSelect(choosedComponent) {
    if (choosedComponent === 'Wyloguj') {
      this.cookieService.set( 'userMail', '');
      this.toastr.success('Wylogowales sie');
      this.router.navigate(['login']);
    }
    this.selectedComponent = choosedComponent;
  }
}
