import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { LoginServiceService } from '../Services/login.service';
import { IResponseafterLogin } from '../Interfaces/iresponseafter-login';
import { IUser } from '../Interfaces/iuser';
import { CookieService } from 'ngx-cookie-service';
import { ToastrService } from 'ngx-toastr';


@Component({
  selector: 'app-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.css']
})

export class LoginComponent implements OnInit {
  constructor(private loginServiceService: LoginServiceService,
              public router: Router,
              private cookieService: CookieService,
              private toastr: ToastrService) {}

  loged = true;
  logedInDb: IResponseafterLogin;
  registerInDb: IResponseafterLogin;
  infoInvaliData = '';
  user: IUser = {name: '', password: '', mail: '', telNumber: 0, isPaid: false};

  ngOnInit() {
    this.loged = true;
  }

  async logIn() {

    if ( this.loged === false) {
      this.infoInvaliData = '';
      this.loged = true;
      return;
    }

    this.logedInDb = await this.loginServiceService.checkIsUser(this.user);
    let isAdminLocal = 'false';

    if (this.logedInDb.isAdmin === true) {
      isAdminLocal = 'true';
    } else {
      isAdminLocal = 'false';
    }

    if (this.logedInDb.status === 'Success') {
      this.cookieService.set( 'userMail', this.logedInDb.mail);
      this.cookieService.set( 'userId', this.logedInDb.idUser);
      this.cookieService.set( 'isAdmin', isAdminLocal);
      this.toastr.success('Success!', 'You\'re logged!');
      this.router.navigate(['home']);
    } else {
      this.toastr.error('Invalid email or password');
      this.infoInvaliData = 'Invalid email or password';
    }  
  }

  async register() {

    if ( this.loged === true) {
      this.infoInvaliData = '';
      this.loged = false;
      return;
    }

    this.registerInDb = await this.loginServiceService.register(this.user);
    let isAdminLocal = 'false';

    if (this.registerInDb.isAdmin === true) {
      isAdminLocal = 'true';
    } else {
      isAdminLocal = 'false';
    }

    if (this.registerInDb.status === 'Success') {
      this.cookieService.set( 'userMail', this.registerInDb.mail);
      this.cookieService.set( 'userId', this.registerInDb.idUser);
      this.cookieService.set( 'isAdmin', isAdminLocal);
      this.toastr.success('Success!', 'Register finished success. You\'re logged!');
      this.router.navigate(['home']);
    } else {
      this.toastr.error('Register feild');
      this.infoInvaliData = 'Register feild';
    }
  }
}
