/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { makeParamDecorator } from '../util/decorators';
/**
 * Type of the Inject decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function InjectDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
const ɵ0 = /**
 * @param {?} token
 * @return {?}
 */
(token) => ({ token });
/**
 * Inject decorator and metadata.
 *
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const Inject = makeParamDecorator('Inject', (ɵ0));
/**
 * Type of the Optional decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function OptionalDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
/**
 * Optional decorator and metadata.
 *
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const Optional = makeParamDecorator('Optional');
/**
 * Type of the Self decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function SelfDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
/**
 * Self decorator and metadata.
 *
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const Self = makeParamDecorator('Self');
/**
 * Type of the SkipSelf decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function SkipSelfDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
/**
 * SkipSelf decorator and metadata.
 *
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const SkipSelf = makeParamDecorator('SkipSelf');
/**
 * Type of the Host decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function HostDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
/**
 * Host decorator and metadata.
 *
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const Host = makeParamDecorator('Host');
/**
 * Type of the Attribute decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function AttributeDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
const ɵ1 = /**
 * @param {?=} attributeName
 * @return {?}
 */
(attributeName) => ({ attributeName });
/**
 * Attribute decorator and metadata.
 *
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const Attribute = makeParamDecorator('Attribute', (ɵ1));
export { ɵ0, ɵ1 };
//# sourceMappingURL=data:application/json;base64,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